/*
 * Decompiled with CFR 0.152.
 */
package com.akuleshov7.ktoml.encoders;

import com.akuleshov7.ktoml.TomlOutputConfig;
import com.akuleshov7.ktoml.encoders.TomlArrayEncoder;
import com.akuleshov7.ktoml.encoders.TomlEncoderAttributes;
import com.akuleshov7.ktoml.encoders.TomlInlineTableEncoder;
import com.akuleshov7.ktoml.encoders.TomlMainEncoder;
import com.akuleshov7.ktoml.exceptions.InternalEncodingException;
import com.akuleshov7.ktoml.exceptions.UnsupportedEncodingFeatureException;
import com.akuleshov7.ktoml.tree.nodes.TomlNode;
import com.akuleshov7.ktoml.tree.nodes.pairs.values.TomlBasicString;
import com.akuleshov7.ktoml.tree.nodes.pairs.values.TomlBoolean;
import com.akuleshov7.ktoml.tree.nodes.pairs.values.TomlDateTime;
import com.akuleshov7.ktoml.tree.nodes.pairs.values.TomlDouble;
import com.akuleshov7.ktoml.tree.nodes.pairs.values.TomlLiteralString;
import com.akuleshov7.ktoml.tree.nodes.pairs.values.TomlLong;
import com.akuleshov7.ktoml.tree.nodes.pairs.values.TomlNull;
import com.akuleshov7.ktoml.tree.nodes.pairs.values.TomlValue;
import com.akuleshov7.ktoml.utils.KeysKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.Instant;
import kotlinx.datetime.LocalDate;
import kotlinx.datetime.LocalDateTime;
import kotlinx.datetime.LocalTime;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.PrimitiveKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.encoding.AbstractEncoder;
import kotlinx.serialization.encoding.Encoder;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B)\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u001d\u001a\u00020\u0003H\u0014J\u001c\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020 2\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\"H\u0002J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0014J\u001d\u0010'\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010(\u001a\u00020\u0000H\u0000\u00a2\u0006\u0002\b)J\u0010\u0010*\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0017H\u0016J\u0010\u0010+\u001a\u00020$2\u0006\u0010%\u001a\u00020,H\u0016J\u0018\u0010-\u001a\u00020$2\u0006\u0010.\u001a\u00020\u00192\u0006\u0010/\u001a\u00020\u0003H\u0016J\u0010\u00100\u001a\u00020$2\u0006\u0010%\u001a\u000201H\u0016J\b\u00102\u001a\u00020$H\u0016J\u0010\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u0019H\u0016J\u0010\u00106\u001a\u00020$2\u0006\u0010%\u001a\u00020\"H\u0016J)\u00107\u001a\u00020$\"\u0004\b\u0000\u001082\f\u00109\u001a\b\u0012\u0004\u0012\u0002H80:2\u0006\u0010%\u001a\u0002H8H\u0016\u00a2\u0006\u0002\u0010;J\u0010\u0010<\u001a\u00020$2\u0006\u0010%\u001a\u00020=H\u0016J\u0010\u0010>\u001a\u00020$2\u0006\u0010%\u001a\u00020?H\u0016J\u0010\u0010@\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0003H\u0016J\u0010\u0010A\u001a\u00020$2\u0006\u0010%\u001a\u00020BH\u0016J\u0010\u0010C\u001a\u00020$2\u0006\u0010%\u001a\u00020DH\u0016J\u0010\u0010E\u001a\u00020\u00002\u0006\u0010F\u001a\u00020GH$J\u0018\u0010H\u001a\u00020\u00172\u0006\u00105\u001a\u00020\u00192\u0006\u0010/\u001a\u00020\u0003H\u0016J?\u0010I\u001a\u00020$\"\b\b\u0000\u00108*\u00020 2\u0006\u00105\u001a\u00020\u00192\u0006\u0010/\u001a\u00020\u00032\f\u00109\u001a\b\u0012\u0004\u0012\u0002H80:2\b\u0010%\u001a\u0004\u0018\u0001H8H\u0016\u00a2\u0006\u0002\u0010JJ\u0018\u0010K\u001a\u00020\u00172\u0006\u00105\u001a\u00020\u00192\u0006\u0010/\u001a\u00020\u0003H\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u00105\u001a\u00020\u00192\u0006\u0010/\u001a\u00020\u0003H\u0014J\u0010\u0010L\u001a\u00020$2\u0006\u0010\u001f\u001a\u00020\"H\u0004J\u001a\u0010M\u001a\u00020\u00002\u0006\u0010N\u001a\u00020O2\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u0014J\u0010\u0010P\u001a\u00020\u00002\u0006\u0010N\u001a\u00020OH\u0014J\u0010\u0010Q\u001a\u00020\u00002\u0006\u0010N\u001a\u00020OH\u0014R\u001a\u0010\u0002\u001a\u00020\u0003X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006R"}, d2={"Lcom/akuleshov7/ktoml/encoders/TomlAbstractEncoder;", "Lkotlinx/serialization/encoding/AbstractEncoder;", "elementIndex", "", "attributes", "Lcom/akuleshov7/ktoml/encoders/TomlEncoderAttributes;", "outputConfig", "Lcom/akuleshov7/ktoml/TomlOutputConfig;", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "<init>", "(ILcom/akuleshov7/ktoml/encoders/TomlEncoderAttributes;Lcom/akuleshov7/ktoml/TomlOutputConfig;Lkotlinx/serialization/modules/SerializersModule;)V", "getElementIndex", "()I", "setElementIndex", "(I)V", "getAttributes", "()Lcom/akuleshov7/ktoml/encoders/TomlEncoderAttributes;", "getOutputConfig", "()Lcom/akuleshov7/ktoml/TomlOutputConfig;", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "isNextElementKey", "", "instantDescriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "localDateTimeDescriptor", "localDateDescriptor", "localTimeDescriptor", "nextElementIndex", "encodeAsKey", "key", "", "type", "", "appendValue", "", "value", "Lcom/akuleshov7/ktoml/tree/nodes/pairs/values/TomlValue;", "appendValueTo", "parent", "appendValueTo$ktoml_core", "encodeBoolean", "encodeDouble", "", "encodeEnum", "enumDescriptor", "index", "encodeLong", "", "encodeNull", "encodeInline", "Lkotlinx/serialization/encoding/Encoder;", "descriptor", "encodeString", "encodeSerializableValue", "T", "serializer", "Lkotlinx/serialization/SerializationStrategy;", "(Lkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;)V", "encodeByte", "", "encodeShort", "", "encodeInt", "encodeFloat", "", "encodeChar", "", "encodeStructure", "kind", "Lkotlinx/serialization/descriptors/SerialKind;", "shouldEncodeElementDefault", "encodeNullableSerializableElement", "(Lkotlinx/serialization/descriptors/SerialDescriptor;ILkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;)V", "encodeElement", "setKey", "arrayEncoder", "rootNode", "Lcom/akuleshov7/ktoml/tree/nodes/TomlNode;", "inlineTableEncoder", "tableEncoder", "ktoml-core"})
public abstract class TomlAbstractEncoder
extends AbstractEncoder {
    private int elementIndex;
    @NotNull
    private final TomlEncoderAttributes attributes;
    @NotNull
    private final TomlOutputConfig outputConfig;
    @NotNull
    private final SerializersModule serializersModule;
    private boolean isNextElementKey;
    @NotNull
    private final SerialDescriptor instantDescriptor;
    @NotNull
    private final SerialDescriptor localDateTimeDescriptor;
    @NotNull
    private final SerialDescriptor localDateDescriptor;
    @NotNull
    private final SerialDescriptor localTimeDescriptor;

    protected TomlAbstractEncoder(int elementIndex, @NotNull TomlEncoderAttributes attributes, @NotNull TomlOutputConfig outputConfig, @NotNull SerializersModule serializersModule) {
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        Intrinsics.checkNotNullParameter((Object)outputConfig, (String)"outputConfig");
        Intrinsics.checkNotNullParameter((Object)serializersModule, (String)"serializersModule");
        this.elementIndex = elementIndex;
        this.attributes = attributes;
        this.outputConfig = outputConfig;
        this.serializersModule = serializersModule;
        this.instantDescriptor = Instant.Companion.serializer().getDescriptor();
        this.localDateTimeDescriptor = LocalDateTime.Companion.serializer().getDescriptor();
        this.localDateDescriptor = LocalDate.Companion.serializer().getDescriptor();
        this.localTimeDescriptor = LocalTime.Companion.serializer().getDescriptor();
    }

    protected final int getElementIndex() {
        return this.elementIndex;
    }

    protected final void setElementIndex(int n) {
        this.elementIndex = n;
    }

    @NotNull
    protected final TomlEncoderAttributes getAttributes() {
        return this.attributes;
    }

    @NotNull
    protected final TomlOutputConfig getOutputConfig() {
        return this.outputConfig;
    }

    @NotNull
    public SerializersModule getSerializersModule() {
        return this.serializersModule;
    }

    protected int nextElementIndex() {
        ++this.elementIndex;
        return this.elementIndex;
    }

    private final boolean encodeAsKey(Object key, String type) {
        if (!this.isNextElementKey) {
            return false;
        }
        this.isNextElementKey = false;
        if (!(key instanceof String)) {
            throw new UnsupportedEncodingFeatureException("Arbitrary map key (" + key + ") types are not supported. Must be either a string or enum. Provide a custom serializer for " + type + " to either of the supported key types.");
        }
        this.setKey((String)key);
        return true;
    }

    static /* synthetic */ boolean encodeAsKey$default(TomlAbstractEncoder tomlAbstractEncoder, Object object, String string, int n, Object object2) {
        if (object2 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: encodeAsKey");
        }
        if ((n & 2) != 0) {
            string = null;
        }
        return tomlAbstractEncoder.encodeAsKey(object, string);
    }

    protected void appendValue(@NotNull TomlValue value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.attributes.reset();
    }

    public final void appendValueTo$ktoml_core(@NotNull TomlValue value, @NotNull TomlAbstractEncoder parent) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)((Object)parent), (String)"parent");
        parent.appendValue(value);
    }

    public void encodeBoolean(boolean value) {
        if (!this.encodeAsKey(value, "Boolean")) {
            this.appendValue(new TomlBoolean(value));
        }
    }

    public void encodeDouble(double value) {
        if (!this.encodeAsKey(value, "Double")) {
            this.appendValue(new TomlDouble(value));
        }
    }

    public void encodeEnum(@NotNull SerialDescriptor enumDescriptor, int index) {
        Intrinsics.checkNotNullParameter((Object)enumDescriptor, (String)"enumDescriptor");
        this.encodeString(enumDescriptor.getElementName(index));
    }

    public void encodeLong(long value) {
        if (!this.encodeAsKey(value, "Long")) {
            this.appendValue(new TomlLong(value, this.attributes.getIntRepresentation()));
        }
    }

    public void encodeNull() {
        this.appendValue(new TomlNull());
    }

    @NotNull
    public Encoder encodeInline(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.encodeElement(descriptor, 0);
        return (Encoder)this;
    }

    public void encodeString(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (!TomlAbstractEncoder.encodeAsKey$default(this, value, null, 2, null)) {
            this.appendValue(this.attributes.isLiteral() ? (TomlValue)new TomlLiteralString(value, this.attributes.isMultiline()) : (TomlValue)new TomlBasicString((Object)value, this.attributes.isMultiline()));
        }
    }

    public <T> void encodeSerializableValue(@NotNull SerializationStrategy<? super T> serializer, T value) {
        Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
        SerialDescriptor desc = serializer.getDescriptor();
        if (Intrinsics.areEqual((Object)desc, (Object)this.instantDescriptor) || Intrinsics.areEqual((Object)desc, (Object)this.localDateTimeDescriptor) || Intrinsics.areEqual((Object)desc, (Object)this.localDateDescriptor) || Intrinsics.areEqual((Object)desc, (Object)this.localTimeDescriptor)) {
            Intrinsics.checkNotNull(value, (String)"null cannot be cast to non-null type kotlin.Any");
            if (!this.encodeAsKey(value, desc.getSerialName())) {
                this.appendValue(new TomlDateTime(value));
            }
        } else {
            SerialKind kind = desc.getKind();
            if (kind instanceof StructureKind || kind instanceof PolymorphicKind) {
                if (desc.isInline()) {
                    serializer.serialize((Encoder)this, value);
                } else {
                    Intrinsics.checkNotNull(value, (String)"null cannot be cast to non-null type kotlin.Any");
                    if (!this.encodeAsKey(value, desc.getSerialName())) {
                        TomlAbstractEncoder encoder = this.encodeStructure(kind);
                        serializer.serialize((Encoder)encoder, value);
                        this.elementIndex = encoder.elementIndex;
                        this.attributes.reset();
                    }
                }
            } else {
                super.encodeSerializableValue(serializer, value);
            }
        }
    }

    public void encodeByte(byte value) {
        this.encodeLong(value);
    }

    public void encodeShort(short value) {
        this.encodeLong(value);
    }

    public void encodeInt(int value) {
        this.encodeLong(value);
    }

    public void encodeFloat(float value) {
        this.encodeDouble(value);
    }

    public void encodeChar(char value) {
        this.appendValue(new TomlLiteralString(String.valueOf(value), false, 2, null));
    }

    @NotNull
    protected abstract TomlAbstractEncoder encodeStructure(@NotNull SerialKind var1);

    public boolean shouldEncodeElementDefault(@NotNull SerialDescriptor descriptor, int index) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return !this.outputConfig.getIgnoreDefaultValues();
    }

    public <T> void encodeNullableSerializableElement(@NotNull SerialDescriptor descriptor, int index, @NotNull SerializationStrategy<? super T> serializer, @Nullable T value) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
        if (value != null || !this.outputConfig.getIgnoreNullValues()) {
            super.encodeNullableSerializableElement(descriptor, index, serializer, value);
        }
    }

    public boolean encodeElement(@NotNull SerialDescriptor descriptor, int index) {
        SerialKind serialKind;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (this.isNextElementKey(descriptor, index)) {
            return true;
        }
        this.nextElementIndex();
        SerialDescriptor typeDescriptor = descriptor.getElementDescriptor(index);
        List typeAnnotations = typeDescriptor.getAnnotations();
        List elementAnnotations = descriptor.getElementAnnotations(index);
        this.attributes.set(typeAnnotations);
        this.attributes.set(elementAnnotations);
        if (!this.attributes.isInline() && Intrinsics.areEqual((Object)typeDescriptor.getKind(), (Object)StructureKind.LIST.INSTANCE) && ((serialKind = typeDescriptor.getElementDescriptor(0).getKind()) instanceof PrimitiveKind || Intrinsics.areEqual((Object)serialKind, (Object)SerialKind.ENUM.INSTANCE) || Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.LIST.INSTANCE))) {
            this.attributes.setInline(true);
        }
        if (this.attributes.isInline() && Intrinsics.areEqual((Object)descriptor.getKind(), (Object)StructureKind.LIST.INSTANCE) && ((serialKind = typeDescriptor.getKind()) instanceof PrimitiveKind || Intrinsics.areEqual((Object)serialKind, (Object)SerialKind.ENUM.INSTANCE))) {
            this.attributes.setMultiline(false);
        }
        return true;
    }

    protected boolean isNextElementKey(@NotNull SerialDescriptor descriptor, int index) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        SerialKind kind = descriptor.getKind();
        if (Intrinsics.areEqual((Object)kind, (Object)StructureKind.CLASS.INSTANCE)) {
            if (!descriptor.isInline() || this.attributes.getKey() == null) {
                this.setKey(descriptor.getElementName(index));
            }
        } else if (Intrinsics.areEqual((Object)kind, (Object)StructureKind.MAP.INSTANCE)) {
            if (index % 2 == 0) {
                this.isNextElementKey = true;
                return true;
            }
        } else if (kind instanceof PolymorphicKind) {
            this.setKey(descriptor.getElementName(index));
            if (index == 0) {
                this.nextElementIndex();
                return true;
            }
        } else {
            throw new InternalEncodingException("Unknown parent kind: " + kind + '.');
        }
        return false;
    }

    protected final void setKey(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.attributes.setKey(KeysKt.isBareKey(key) ? key : (KeysKt.isLiteralKeyCandidate(key) ? '\'' + key + '\'' : '\"' + key + '\"'));
    }

    @NotNull
    protected TomlAbstractEncoder arrayEncoder(@NotNull TomlNode rootNode, @NotNull TomlEncoderAttributes attributes) {
        Intrinsics.checkNotNullParameter((Object)rootNode, (String)"rootNode");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        return new TomlArrayEncoder(rootNode, this, this.elementIndex, attributes, this.outputConfig, this.getSerializersModule());
    }

    public static /* synthetic */ TomlAbstractEncoder arrayEncoder$default(TomlAbstractEncoder tomlAbstractEncoder, TomlNode tomlNode, TomlEncoderAttributes tomlEncoderAttributes, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: arrayEncoder");
        }
        if ((n & 2) != 0) {
            tomlEncoderAttributes = tomlAbstractEncoder.attributes.child();
        }
        return tomlAbstractEncoder.arrayEncoder(tomlNode, tomlEncoderAttributes);
    }

    @NotNull
    protected TomlAbstractEncoder inlineTableEncoder(@NotNull TomlNode rootNode) {
        Intrinsics.checkNotNullParameter((Object)rootNode, (String)"rootNode");
        return new TomlInlineTableEncoder(rootNode, this, this.elementIndex, this.attributes.child(), this.outputConfig, this.getSerializersModule());
    }

    @NotNull
    protected TomlAbstractEncoder tableEncoder(@NotNull TomlNode rootNode) {
        Intrinsics.checkNotNullParameter((Object)rootNode, (String)"rootNode");
        return new TomlMainEncoder(rootNode, this.elementIndex, this.attributes.child(), this.outputConfig, this.getSerializersModule());
    }
}

